<?php

namespace Modules\Playground\Controllers;

use App\Helpers\ApiResponse;
use App\Http\Requests\Admin\Playgrounds\Store;
use Illuminate\Http\Request;
use Modules\Areas\Models\Area;
use Modules\Common\Controllers\Admin\HelperController;
use Modules\Playground\Models\Playground;
use MshMsh\Helpers\ApiResponder;

class AdminController extends HelperController
{
    public $latName;
    public $lngName;
    public $addressName;
    public function __construct()
    {
        $this->model = new Playground();
        $this->rows = $this->model->with('category');


        $this->title = "Playground";
        $this->name = 'playgrounds';
        $this->has_map = true;
        $this->formRequest = Store::class;
        // $this->switches['status'] = route('admin.playgrounds.active_status');
        $this->latName = 'Latitude';
        $this->lngName = 'Longitude';
        $this->addressName = 'Address';
    }

    public function index()
    {
        if (!isset($this->rows)) {
            $this->rows = $this->model;
        }

        if (request()->has('q') && request('q')) {
            $ids = Playground::search(request('q'))->keys();
            $this->rows = $this->rows->whereIn('id', $ids);
        } else {
            $this->search();
        }

        if (request()->has('Accessibility') && request('Accessibility') != null) {
            $this->rows = $this->rows->where('Accessibility', 'like', '%' . request('Accessibility') . '%');
        }

        $this->listBuilder();

        $this->check_user_roles();

        $this->treeViewBuilder();

        $this->rows = $this->rows->latest()->paginate(25);

        $this->locale = app()->getLocale();

        $this->requestQueries = request()->query();
        foreach (request()->query() as $key => $value) {
            unset($this->requestQueries[$key]);
        }

        return view('Common::admin.list', get_object_vars($this));
    }

    public function listBuilder()
    {
        $this->list = [
            'Name' => __('Name'),
            'Owner' => __('Owner'),
            'category_name' => __('Category'),
            'City' => __('City'),
            'Grass_Type' => __('Grass Type'),
            'Accessibility' => __('Accessibility'),
            'status_html' => __('Status'),
            'created_at' => __('Created At'),
            // 'slots' => __('Slots'),
        ];
    }

    public function formBuilder()
    {
        $categories = \Modules\Categories\Models\Category::pluck('name', 'id')->toArray();
        $Owner = \Modules\User\Models\User::where('role_id', 1)->pluck('FirstName', 'id')->toArray();

        $this->inputs = [
            'Name' => ['title' => __('Name')],
            'organizer_user_id' => ['title' => __('organizer'), 'type' => 'select', 'values' => $Owner],
            'Owner' => ['title' => __('Owner Name')],
            'Category_ID' => ['title' => __('Category'), 'type' => 'select', 'values' => $categories],
            'City' => ['title' => __('City')],
            'Telephone' => ['title' => __('Telephone')],
            'Email' => ['title' => __('Email')],
            'Grass_Type' => ['title' => __('Grass Type')],
            'Accessibility' => ['title' => __('Accessibility'), 'type' => 'select', 'values' => ['Public' => __('Public Access'), 'Private' => __('Private')]],
            'Address' => ['title' => __('Address')],
            'Latitude' => ['title' => __('Latitude')],
            'Longitude' => ['title' => __('Longitude')],
            'status' => ['title' => __('Status'), 'type' => 'select', 'values' => ['active' => __('Active'), 'inactive' => __('Inactive'), 'pending' => __('pending')]],
            'slots[]' => ['title' => __('Slots'), 'type' => 'select', 'values' => ['3' => '3x3', '5' => '5x5', '7' => '7x7', '11' => '11x11'], 'multiple' => 'multiple'],

            'Disability_Parking' => ['title' => __('Disability Parking'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
            'Disability_Activity_Areas' => ['title' => __('Disability Activity Areas'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
            'Disability_Social_Areas' => ['title' => __('Disability Social Areas'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
            'Disability_Spectator_Areas' => ['title' => __('Disability Spectator Areas'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
            'Disability_Changing_Facilities' => ['title' => __('Disability Changing Facilities'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
            'Disability_Toilets' => ['title' => __('Disability Toilets'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
            'Disability_Finding_and_Reaching_the_Entrance' => ['title' => __('Disability Finding and Reaching the Entrance'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
            'Disability_Reception_Area' => ['title' => __('Disability Reception Area'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
            'Disability_Doorways' => ['title' => __('Disability Doorways'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
            'Disability_Emergency_Exits' => ['title' => __('Disability Emergency Exits'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],

            'media[]' => ['title' => __('Image/Video'), 'type' => 'image', 'multiple' => true],
        ];
    }





    public function active_status(Request $request)
    {
        $playground = Playground::findOrFail($request->id);
        $playground->update(['status' => $request->status]);
        return ApiResponse::get('', ['status' => 1]);
    }

    public function setImages($model)
    {
        // Prevent default image creation logic
    }
}
