<?php

namespace Modules\Match\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateMatchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'playground_id' => 'sometimes|required',
            'date' => 'sometimes|required',
            'name' => 'sometimes|string',
            'price' => 'sometimes|required',
            'About' => 'sometimes|string',
            'gender' => 'nullable|in:male,female,co_ed',
            'status' => 'nullable|in:completed,cancelled',
            'players_per_side' => 'sometimes|required',
            'start_time' => 'sometimes|required',
            'end_time' => 'sometimes|required',
        ];
    }
}
