<?php
// تجهيز البيانات: نتأكد أننا نأخذ القيم من الأكسيسور أو نضع قيماً افتراضية (الرياض)
$locObject = $model->location; 
$defaultLat = 24.7136; // إحداثيات افتراضية (الرياض)
$defaultLng = 46.6753;

$currentLat = $locObject->latitude ?? $defaultLat;
$currentLng = $locObject->longitude ?? $defaultLng;
$currentAddress = $locObject->address ?? '';
?>

<div class="col-xs-12">
    <div class="flexSection">
        <div class="inputSection postInput-section mapbox">
            <p class="inputHeader">
                {{ __('Location on map') }}
            </p>
            
            <div class="row">
                <div class="col-sm-6">
                    <input type="hidden" 
                           id="map-lat" 
                           name="Latitude" 
                           value="{{ $currentLat }}">
                </div>

                <div class="col-sm-6">
                    <input type="hidden" 
                           id="map-lng" 
                           name="Longitude" 
                           value="{{ $currentLng }}">
                </div>
            </div>

            <input type="text" 
                   id="map-location" 
                   name="Address"
                   value="{{ $currentAddress }}"
                   class="form-control input__ map-location" 
                   placeholder="{{ __('Enter your location') }}">
            <br>
            
            <input type="hidden" id="locationBtn">
            <div id="map" style="height:300px; width:100%; overflow:hidden; border-radius: 8px;"></div>
        </div>
    </div>
</div>

<div class="modal fade notInside_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal_block__">
                <h2 class="title rating_title__">
                    <p class="parag_head__">@lang('Warning')</p>
                </h2>
                <p class="parag__">
                    {{ __('This point is not within its scope') }}
                </p>
            </div>
        </div>
    </div>
</div>

<script>
    var map, marker, geocoder, autocomplete;
    var mapDiv = document.getElementById('map');
    
    // القيم الأولية القادمة من PHP
    var initialLat = parseFloat("{{ $currentLat }}");
    var initialLng = parseFloat("{{ $currentLng }}");

    $(document).ready(function() {
        // تشغيل الخريطة عند تحميل الصفحة
        initMap();
        
        // عند اللصق في حقل العنوان
        $('#map-location').bind("paste", function() {
            var input = $(this);
            setTimeout(function() {
                geoCodeAddress(input.val());
            }, 500);
        });
    });

    function initMap() {
        $('#map').show(); // إظهار ديف الخريطة

        geocoder = new google.maps.Geocoder();
        
        var myLatlng = { lat: initialLat, lng: initialLng };

        // إعداد الخريطة
        map = new google.maps.Map(mapDiv, {
            center: myLatlng,
            zoom: 14,
            streetViewControl: false,
        });

        // إعداد الماركر
        marker = new google.maps.Marker({
            position: myLatlng,
            map: map,
            icon: "{{ url('assets/marker.svg') }}", // تأكد أن المسار للصورة صحيح
            draggable: true,
            animation: google.maps.Animation.DROP
        });

        // إعداد الإكمال التلقائي (Autocomplete)
        var input = document.getElementById('map-location');
        autocomplete = new google.maps.places.Autocomplete(input);
        autocomplete.bindTo('bounds', map);
        autocomplete.addListener('place_changed', fillInAddress);

        // إضافة زر "موقعي الحالي"
        addYourLocationButton(map, marker);

        // --- الأحداث (Events) ---

        // 1. عند النقر على الخريطة
        map.addListener('click', function(event) {
            updateMarkerPosition(event.latLng);
        });

        // 2. عند سحب الماركر وانتهاء السحب
        marker.addListener('dragend', function(event) {
            updateMarkerPosition(event.latLng);
        });

        // تحديث الحقول المخفية لأول مرة
        updateHiddenInputs(initialLat, initialLng);
    }

    // دالة لتحديث موقع الماركر والبيانات
    function updateMarkerPosition(latLng) {
        marker.setPosition(latLng);
        map.panTo(latLng);
        
        var lat = latLng.lat();
        var lng = latLng.lng();

        updateHiddenInputs(lat, lng);
        getAddressFromLatLing(latLng); // جلب العنوان النصي (Reverse Geocoding)
    }

    // دالة تحديث الحقول المخفية (Lat, Lng)
    function updateHiddenInputs(lat, lng) {
        $('#map-lat').val(lat);
        $('#map-lng').val(lng);
    }

    // دالة جلب العنوان من الإحداثيات
    function getAddressFromLatLing(latLng) {
        geocoder.geocode({ 'location': latLng, 'language': 'ar' }, function(results, status) {
            if (status === 'OK') {
                if (results[0]) {
                    $('#map-location').val(results[0].formatted_address);
                } else {
                    console.log('No results found');
                }
            } else {
                console.log('Geocoder failed due to: ' + status);
            }
        });
    }

    // دالة عند اختيار عنوان من القائمة المنسدلة
    function fillInAddress() {
        var place = autocomplete.getPlace();
        if (!place.geometry) {
            return;
        }
        
        // إذا كان المكان له إحداثيات
        if (place.geometry.viewport) {
            map.fitBounds(place.geometry.viewport);
        } else {
            map.setCenter(place.geometry.location);
            map.setZoom(17);
        }

        marker.setPosition(place.geometry.location);
        updateHiddenInputs(place.geometry.location.lat(), place.geometry.location.lng());
    }

    // دالة البحث اليدوي (عند اللصق مثلاً)
    function geoCodeAddress(address) {
        if (!address) return;
        geocoder.geocode({ 'address': address }, function(results, status) {
            if (status === 'OK') {
                map.setCenter(results[0].geometry.location);
                marker.setPosition(results[0].geometry.location);
                updateHiddenInputs(results[0].geometry.location.lat(), results[0].geometry.location.lng());
            } else {
                alert('Geocode was not successful: ' + status);
            }
        });
    }

    // دالة إضافة زر "موقعي الحالي"
    function addYourLocationButton(map, marker) {
        var controlDiv = document.createElement('div');
        
        var firstChild = document.createElement('button');
        firstChild.style.backgroundColor = '#fff';
        firstChild.style.border = 'none';
        firstChild.style.outline = 'none';
        firstChild.style.width = '40px';
        firstChild.style.height = '40px';
        firstChild.style.borderRadius = '2px';
        firstChild.style.boxShadow = '0 1px 4px rgba(0,0,0,0.3)';
        firstChild.style.cursor = 'pointer';
        firstChild.style.marginRight = '10px';
        firstChild.style.marginBottom = '10px';
        firstChild.style.padding = '0';
        firstChild.title = 'Your Location';
        controlDiv.appendChild(firstChild);

        var secondChild = document.createElement('div');
        secondChild.style.margin = '11px';
        secondChild.style.width = '18px';
        secondChild.style.height = '18px';
        secondChild.style.backgroundImage = 'url(https://maps.gstatic.com/tactile/mylocation/mylocation-sprite-1x.png)';
        secondChild.style.backgroundSize = '180px 18px';
        secondChild.style.backgroundPosition = '0px 0px';
        secondChild.style.backgroundRepeat = 'no-repeat';
        firstChild.appendChild(secondChild);

        firstChild.addEventListener('click', function() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                    var latlng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
                    updateMarkerPosition(latlng);
                });
            }
        });

        controlDiv.index = 1;
        map.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push(controlDiv);
    }
</script>