<?php

namespace Modules\Categories\Controllers;

use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use App\Traits\ApiResponsee;
use Modules\Categories\Models\Category;
use Modules\Categories\Resources\CategoryCollection;
use Modules\Categories\Resources\CategoryResource;
use Modules\Categories\Requests\StoreCategoryRequest;
use Modules\Categories\Services\CategoryService;

class ApiController extends Controller
{
    use ApiResponsee;

    protected $categoryService;

    public function __construct(CategoryService $categoryService)
    {
        $this->categoryService = $categoryService;
    }
    
    public function index()                                                                                                                 
    {   
        $categories = $this->categoryService->getAll();

        if (!$categories) {
       $errors = $this->categoryService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new CategoryCollection($categories), 200, 'success');
    }

    public function store(StoreCategoryRequest $request)
    {
        $category = $this->categoryService->create($request->validated());


        if (!$category) {
           $errors = $this->categoryService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new CategoryResource($category), 200, 'success');
    }

    public function show($id)
    {
        $category = $this->categoryService->findById($id);

        if (!$category) {
         $errors = $this->categoryService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new CategoryResource($category), 200, 'success');
    }



    public function update(StoreCategoryRequest $request, $id)
    {
        $category = $this->categoryService->update($id, $request->validated());

        if (!$category) {
            $errors = $this->categoryService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new CategoryResource($category), 200, 'success');
    }


    public function destroy($id)
    {
        $deleted = $this->categoryService->delete($id);

        if (!$deleted) {
        
        $errors = $this->categoryService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
        }
             return ApiResponse::loaded(null, 200, 'success');
    }


}
