<?php

namespace Modules\User\Controllers\Api;

use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Support\Facades\Request;
use Modules\User\Models\Otp;
use Modules\User\Models\User;
use Modules\User\Requests\CheckMobileOtpRequest;
use Modules\User\Requests\LoginRequest;
use Modules\User\Requests\LogoutRequest;
use Modules\User\Requests\RegisterRequest;
use Modules\User\Requests\SendMobileOtpRequest;
use Modules\User\Requests\SignUpPlayGroundMaster;
use Modules\User\Requests\ValidationPageRequst;
use Modules\User\Requests\VerifyOtpRequest;
use Modules\User\Resources\UserResource;
use Modules\User\Services\AuthService;
use Modules\User\Services\UserService;

class AuthController extends Controller
{

    protected $authService;
    public function  __construct(AuthService $authService)
    {

        $this->authService = $authService;
    }

    public function signupPlayGroundMaster(SignUpPlayGroundMaster $request)
    {
        $result = $this->authService->registerplaygroundmaster($request->validated());
        if (!$result) {
            $errors = $this->authService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        // $result contains 'user' and 'message' now, no token yet
        return ApiResponse::created($result, __('messages.User created successfully. Please verify your email.'));
    }


    public function signupPlayer(RegisterRequest $request)
    {
        $result = $this->authService->registerplayer($request->validated());

       
        if (!$result) {

            $errors = $this->authService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::created($result, __('messages.User created successfully. Please verify your email.'));

    }



    public function login(LoginRequest $request)
    {
        $result = $this->authService->login($request->validated());

        if ($result === 'not_active') {
            return ApiResponse::failed(__('messages.Account is not active. Please verify your email.'), 406);
        }

        if (!$result) {
            return ApiResponse::failed(__('messages.Invalid credentials'), 401);
        }

        return ApiResponse::loaded($result, 200, __('messages.User logged in successfully'));
    }


    public function logout(Request $request)
    {
        $user = auth("api")->user();
        $this->authService->logout($user);
        return ApiResponse::loaded(null, 200, __('messages.Logged out successfully'));
    }

    public function verifyOtp(VerifyOtpRequest $request)
    {
        $result = $this->authService->verifyOtp($request->email, $request->otp);

        if (!$result) {
            return ApiResponse::failed(__('messages.Invalid or expired OTP'), 400);
        }

        return ApiResponse::loaded($result, 200, __('messages.Account verified successfully'));
    }

    public function resendOtp(\Illuminate\Http\Request $request)
    {
        $request->validate(['email' => 'required|email|exists:users,email']);

        $result = $this->authService->resendOtp($request->email);

        if (!$result) {
            return ApiResponse::failed(__('messages.User not found'), 404);
        }

        return ApiResponse::loaded(null, 200, __('messages.OTP sent successfully'));
    }


    public function ValidateRequest(ValidationPageRequst $request)
    {

        $result = $this->authService->ValidateRequest($request->validated());

        if (!$result) {
            $errors = $this->authService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded($result, 200, __('messages.User created successfully. Please verify your email.'));
    }

    public function forgetPassword(\Illuminate\Http\Request $request)
    {
        $request->validate(['email' => 'required|email|exists:users,email']);

        $result = $this->authService->forgetPassword($request->email);

        if (!$result) {
            return ApiResponse::failed(__('messages.User not found'), 404);
        }

        return ApiResponse::loaded(null, 200, __('messages.OTP sent successfully'));
    }

    public function resetPassword(\Illuminate\Http\Request $request)
    {
        $request->validate([
            'email' => 'required|email|exists:users,email',
            'password' => 'required|min:6|confirmed'
        ]);

        $result = $this->authService->resetPassword($request->all());

        if ($result === 'user_not_found') {
            return ApiResponse::failed(__('messages.User not found'), 404);
        }

        return ApiResponse::loaded(null, 200, __('messages.Password reset successfully'));
    }



public function verifyOtpPassword(VerifyOtpRequest $request)
{
    $result = $this->authService->verifyOtpPassword($request->email, $request->otp);

    if (!$result) {
        return ApiResponse::failed(__('messages.Invalid or expired OTP'), 400);
    }

    return ApiResponse::loaded(null, 200, __('messages.Otp verified successfully'));
}




}
