<?php

namespace Modules\Match\Controllers;

use App\Enum\SubscriberStatus;
use App\Enum\UserType;
use App\Helpers\ApiResponse;
use App\Http\Requests\Admin\Matches\Store;
use App\Notifications\MatchSubscribeDeleteNotifications;
use App\Notifications\MatchSubscribeNotifications;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Notifications\Notification;
use Illuminate\Validation\ValidationException;
use libphonenumber\MatchType;
use Modules\Common\Controllers\Admin\HelperController;
use Modules\Match\Models\Matche;
use Modules\Match\Models\Subscriber;
use Modules\Playground\Models\Playground;
use Modules\User\Models\User;
use MshMsh\Helpers\ApiResponder;

class AdminController extends HelperController
{
    protected $view;
    public function __construct()
    {
        $this->model = new Matche();
        $this->rows = $this->model->with('playground');
        $this->title = "Match";
        $this->name = 'matches';
        $this->formRequest = Store::class;
        $this->canShow = true;
        $this->view = 'Match::admin.form';
    }

    public function listBuilder()
    {
        $this->list = [
            'playground_Name' => __('playground'),
            'name' => __('name'),
            'About' => __('About Match'),
            'date' => __('date'),
            'start_time' => __('start time'),
            'end_time' => __('end time'),
            'price' => __('price'),
            'players_per_side' => __('players per side'),
            'gender' => __('gender'),
            'status_text' => __('status'),
        ];
    }

    public function formBuilder()
    {
        $playgrounds = Playground::active()->pluck('name', 'id');
        $supervisors = User::where('role_id', 1)->pluck('FirstName', 'id'); // Assuming role_id 1 is for playground master/organizer
        $this->inputs = [
            'playground_id' => ['title' => __('playground'), 'type' => 'select', 'values' => $playgrounds],
            'organizer_user_id' => ['title' => __('organizer'), 'type' => 'select', 'values' => $supervisors],
            'name' => ['title' => __('name'), 'type' => 'text'],
            'About' => ['title' => __('About Match'), 'type' => 'text'],
            'date' => ['title' => __('date'), 'type' => 'date'],
            'start_time' => ['title' => __('start time'), 'type' => 'time'],
            'end_time' => ['title' => __('end time'), 'type' => 'time'],
            'players_per_side' => ['title' => __('players per side'), 'type' => 'number'],
            'price' => ['title' => __('price'), 'type' => 'number'],
            'gender' => ['title' => __('gender'), 'type' => 'select', 'values' => ['male' => __('male'), 'female' => __('female'), 'co_ed' => __('co_ed')]],
            'status' => ['title' => __('Status'), 'type' => 'select', 'values' => ['open' => __('Open'), 'ongoing' => __('Ongoing'), 'completed' => __('Completed'), 'cancelled' => __('Cancelled')]],
            'paid_online' => ['title' => __('Paid Online'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
            'refund' => ['title' => __('Refund'), 'type' => 'select', 'values' => [1 => __('Yes'), 0 => __('No')]],
        ];
    }
    public function active_status(Request $request)
    {
        $match = Matche::findOrFail($request->id);
        // Toggle logic: if open -> cancelled, if cancelled -> open. 
        // Other statuses might not be toggleable via this simple switch, or you can define specific transitions.
        if ($match->status == 'open') {
            $match->update(['status' => 'cancelled']);
        } elseif ($match->status == 'cancelled') {
            $match->update(['status' => 'open']);
        }

        return ApiResponse::get('', ['status' => $match->status]);
    }
    public function show($id)
    {
        $match = Matche::findOrFail($id)->load('playground', 'teamPlayers');
        $title =   __("show match");
        $input = [
            "title" => __("users"),
            "name" => "user_id",
            "type" => "ajax_select",
            "action" => route('admin.get_users'),
            "values" => [],
            "empty" => 0
        ];
        $model = new User();
        return view('Match::show', get_defined_vars());
    }

    public function get_slots(Request $request)
    {
        $playground = Playground::find($request->playground_id);
        if ($playground && $playground->slots) {
            $slots = [];
            foreach ($playground->slots as $slot) {
                $slots[$slot] = $slot;
            }
            return response()->json($slots);
        }
        return response()->json([]);
    }
}
