<?php

namespace Modules\Location\Controllers;

use App\Helpers\ApiResponse;
use Illuminate\Http\Request;
use Modules\Areas\Models\Area;
use Modules\Common\Controllers\Admin\HelperController;
use Modules\Location\Models\Location;
use MshMsh\Helpers\ApiResponder;

class AdminController extends HelperController
{
    public function __construct()
    {
        $this->model = new Location();

        $this->title = "Location";
        $this->name = 'locations';
        $this->list = ['name' => __('name')];
        $this->switches['status'] = route('admin.locations.active_status');
    }

    public function listBuilder()
    {
        $this->list = [
            'name' => __('name'),
        ];
    }

    public function formBuilder()
    {
        $this->inputs = [
            'name' => ['title' => __('name')],
            'name_ar' => ['title' => __('name_ar')],
        ];
    }

    public function destroy($id)
    {
        $model = $this->model->findOrFail($id);
        if ($model->users()->exists()) {
            return $this->failedfullResponse(__('This location has associated users.'));
        }
        $model->delete();

        return $this->successfullResponse();
    }
    public function active_status(Request $request)
    {
        $location = Location::findOrFail($request->id);
        $location->update(['status' => !$location->status]);
        return ApiResponse::get('', ['status' => 1]);
    }
}
