<?php

namespace Modules\User\Services;

use App\Services\Services;
use Illuminate\Support\Facades\DB;
use Modules\Match\Models\Matche;
use Modules\User\Models\User;

class ApiService extends Services
{

    private $coloums = ['id', 'name', 'email', 'mobile', 'role_id', 'location_id', 'created_at', 'updated_at'];


    public function index()
    {

        $column = request('sort_by', null);
        $order = request('sort_order') ?: 'desc';
        $name = request('name', null);
        $email = request('email', null);
        $mobile = request('mobile', null);
        $query = User::query()
            ->when($name, function ($q, $name) {
                $q->where('name', 'LIKE', "%$name%");
            })->when($email, function ($q, $email) {
                $q->where('email', 'LIKE', "%$email%");
            })->when($mobile, function ($q, $mobile) {
                $q->where('mobile', 'LIKE', "%$mobile%");
            })->when($column && array_key_exists($column, $this->coloums), function ($q) use ($column, $order) {
                $q->orderBy($column, $order);
            });


        return $query->paginate(request('limit', 15));
    }




    public function show($id)
    {

        $user = User::query()->with(['location'])->find($id);
        if (!$user) {
            $this->setError(__('messages.User not found'));
            return false;
        }

        return $user;
    }




    public function Deactivite($id)
    {

        $user = User::query()->find($id);
        if (!$user) {
            $this->setError(__('messages.User not found'));
            return false;
        }
        $user->update([
            'status' => false
        ]);

        return $user;
    }

    public function update($user, $data)
    {

        $image = $data['image'] ?? null;

        unset($data['image']);

        if ($image) {
            $user->image = $image;
        }

        $result =  $user->update($data);

        if (!$result) {
            $this->setError(__('messages.User not found'));
            return false;
        }

        return $result;
    }



    public function averagerating($user)
    {

        $averageRating = $user->reviews()->avg('rating');

        return $averageRating ?? 0;
    }


    public function upcommingmatches($user)
    {
        $matches = $user->teamMatches()->where('status', 'open')->paginate(request('limit', 15));
      
        return $matches;
    }

public function playedmatches($user){

    $matches = $user->teamMatches()->where('status', 'completed')->paginate(request('limit', 15));
    return $matches;
}

    public function delete($id)
    {

        $user = User::query()->find($id);
        if (!$user) {
            $this->setError(__('messages.User not found'));
            return false;
        }
        $user->delete();

        return $user;
    }
}
