<?php

namespace Modules\User\Controllers\Api;

use App\Enum\UserType;
use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use App\Notifications\Couching\AdminNotifications;
use App\Traits\ApiResponsee;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use Illuminate\Validation\ValidationException;
use Modules\Coaching\Models\CoachingRequest;
use Modules\Match\Requests\Subscribe;
use Modules\Match\Resources\MatchCollection;
use Modules\User\Models\Admin;
use Modules\User\Models\Otp;
use Modules\User\Requests\ConfirmMobileRequest;
use Modules\User\Requests\ProfileUpdateRequest;
use Modules\User\Resources\UserCollection;
use Modules\User\Resources\UserResource;
use Modules\User\Services\ApiService;

class ApiController extends Controller
{
    use ApiResponsee;
    protected $apiservice;
    public function __construct(ApiService $apiservice)
    {
        $this->apiservice = $apiservice;
    }


    public function index()
    {

        $users = $this->apiservice->index();

        $users->load(['location', 'role']);

        if (!$users) {
            $errors = $this->apiservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new UserCollection($users), 200, 'success');
    }



    public function show($id)
    {

        $user = $this->apiservice->show($id);

        if (!$user) {
            $errors = $this->apiservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new UserResource($user), 200, 'success');
    }



    public function Deactivite($id)
    {

        $user = $this->apiservice->Deactivite($id);

        if (!$user) {
            $errors = $this->apiservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new UserResource($user), 200, 'success');
    }


    public function updateprofile(ProfileUpdateRequest $request)
    {
        $user = auth('api')->user();

        $result = $this->apiservice->update($user, $request->validated());

        if (!$result) {
            $errors = $this->apiservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new UserResource($user), 200, 'success');
    }



    public function profile()
    {
        $user = auth('api')->user()->load('location', 'role');

        return ApiResponse::loaded([
            'user' => new UserResource($user)
        ]);
    }

    public function  averagerating()
    {
        $user = auth('api')->user();

        $result = $this->apiservice->averagerating($user);

        if ($result === false) {
         
            $errors = $this->apiservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded($result, 200, 'success');
    }


public function upcommingmatches()
{
    $user = auth('api')->user();

    $result = $this->apiservice->upcommingmatches($user);
    $result->load('user');
     return ApiResponse::loaded(new MatchCollection($result), 200, 'success');
}

public function playedmatches(){


 $user = auth('api')->user();

    $result = $this->apiservice->playedmatches($user);
    $result->load('user');
     return ApiResponse::loaded(new MatchCollection($result), 200, 'success');

}


    public function delete($id)
    {

        $user = $this->apiservice->delete($id);

        if (!$user) {
            $errors = $this->apiservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(null, 200, 'success');
    }




    public function updateNotificationSettings(Request $request)
    {
        $request->validate([
            'key' => 'required|string',
            'value' => 'required|boolean',
        ]);

        $user = auth('api')->user();

        $settings = $user->notification_settings ?? [];

        $settings[$request->key] = $request->value;

        $user->notification_settings = $settings;
        $user->save();

        return ApiResponse::loaded(null, 200, 'success');
    }
}
