<?php

namespace Modules\Reviews\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\User\Resources\UserResource;

class ReviewResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'user' => UserResource::make($this->user),
            'rating' => $this->rating,
            'comment' => $this->comment,
            'review_type' => class_basename($this->reviewable_type),
            'reviewable' => $this->reviewable,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
