<?php

namespace Modules\Reviews\Controllers;

use App\Helpers\ApiResponse;
use Modules\Reviews\Requests\StoreReviewRequest;
use Modules\Reviews\Requests\UpdateReviewRequest;
use Modules\Reviews\Resources\ReviewCollection;
use Modules\Reviews\Resources\ReviewResource;
use Modules\Reviews\Services\ApiService;
use App\Http\Controllers\Controller;
use App\Traits\ApiResponsee;

class ApiController extends Controller
{
    use ApiResponsee;
    protected $apiService;

    public function __construct(ApiService $apiService)
    {

        $this->apiService = $apiService;
    }

    public function index()
    {

        $reviews = $this->apiService->index();
        $reviews->load('user', 'reviewable' , 'user.location');

        if (!$reviews) {
            $errors = $this->apiService->errors();
            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new ReviewCollection($reviews), 200, 'success');
    }

    public function store(StoreReviewRequest $request)
    {

        $review = $this->apiService->store($request->validated());

        if (!$review) {
            $errors = $this->apiService->errors();
            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new ReviewResource($review), 200, 'success');
    }

    public function update(UpdateReviewRequest $request, $id)
    {

        $review = $this->apiService->update($request->validated(), $id);

        if (!$review) {
            $errors = $this->apiService->errors();
            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new ReviewResource($review), 200, 'success');
    }

    public function destroy($id)
    {

        $review = $this->apiService->destroy($id);

        if (!$review) {
            $errors = $this->apiService->errors();
            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new ReviewResource($review), 200, 'success');
    }
}
