<?php

namespace Modules\Playground\Controllers;

use App\Enum\UserType;
use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use App\Traits\ApiResponsee;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Request;
use Modules\Playground\Models\Category;
use Modules\Playground\Resources\PlaygroundListResource;
use Modules\Playground\Resources\PlaygroundResource;
use Modules\Playground\Resources\PlaygroundCollection;
use Modules\Playground\Models\Playground;
use Modules\Playground\Resources\CategoryResource;
use Modules\Playground\Services\PlaygroundService;
use Modules\Playground\Requests\PlaygroundRequest;
use Modules\Playground\Requests\UpdatePlaygroundRequest;

class ApiController extends Controller
{
    use ApiResponsee;

    protected $playgroundService;

    public function __construct(PlaygroundService $playgroundService)
    {
        $this->playgroundService = $playgroundService;
    }


    public function index()
    {   
        $playgrounds = $this->playgroundService->paginate();
        if (!$playgrounds) {
            $errors = $this->playgroundService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new PlaygroundCollection($playgrounds), 200, 'success');
    }


    public function store(PlaygroundRequest $request)
    {
        $playground = $this->playgroundService->store($request->validated());
        if (!$playground) {
            $errors = $this->playgroundService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new PlaygroundResource($playground));
    }


    public function update(UpdatePlaygroundRequest $request, $id)
    {
        $playground = $this->playgroundService->update($request->validated(), $id);
        if (!$playground) {
            $errors = $this->playgroundService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new PlaygroundResource($playground));
    }

    public function destroy($id)
    {
        $playground = $this->playgroundService->destroy($id);
        if (!$playground) {
            $errors = $this->playgroundService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new PlaygroundResource($playground));
    }


    public function show($id)
    {

        $playground = $this->playgroundService->show($id);
        if (!$playground) {
            $errors = $this->playgroundService->errors();
            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new PlaygroundResource($playground));
    }


    public function Deactivite($id)
    {
        $playground = $this->playgroundService->Deactivite($id);
        if (!$playground) {
            $errors = $this->playgroundService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new PlaygroundResource($playground), 200, 'success');
    }


    public function Getnearst()
    {
        $request = request();

        $request->validate([
            'lat' => 'required|numeric',
            'lng' => 'required|numeric',
        ]);

        $playgrounds = $this->playgroundService->getNearest($request->query('lat'), $request->query('lng'));

        if ($playgrounds->isEmpty()) {
            $errors = $this->playgroundService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(PlaygroundResource::collection($playgrounds), 200, 'success');
    }


    public function search(HttpRequest $request)
    {

        $request->validate([
            'query' => 'required|string|min:1',
        ]);
        $playgrounds = Playground::search($request->input('query'))

            ->query(function ($builder) use ($request) {
                $builder->with(['media', 'category', 'user']);
                if ($catId = config('context.category_id')) {
                    $builder->where('Category_ID', $catId);
                }

                if ($request->filled(['latitude', 'longitude'])) {
                    $builder->withDistance($request->latitude, $request->longitude);
                    $builder->orderBy('distance', 'asc');
                }
            })->paginate(request('limit', 15));

        return ApiResponse::loaded(new PlaygroundCollection($playgrounds), 200, 'success');
    }

    public function myplaygrounds()
    {
        $playgrounds = $this->playgroundService->myplaygrounds();
        return ApiResponse::loaded(PlaygroundResource::collection($playgrounds), 200, 'success');
    }
}
