<?php

namespace Modules\User\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProfileUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
    "FirstName"=>"sometimes|string|min:1|max:60",
    "LastName"=>"sometimes|string|min:1|max:60",
    "NickName"=>"sometimes|string|unique:users,NickName",
    "Nationality"=>"sometimes|string",
    'Date_Of_Birth' => [
                        'sometimes',
                        'date',
                        'after_or_equal:1970-01-01',
                        'before_or_equal:2020-12-29',
     ],
     "longitude"=>"sometimes|numeric",
     "latitude"=>"sometimes|numeric",
     "position_id"=>"sometimes|exists:locations,id,deleted_at,NULL",
     "self_Ranking"=>"sometimes|numeric",
     'image' => 'sometimes|image|mimes:jpeg,png,jpg,gif|max:10240',
     "Bio"=>"sometimes|string",
     "Playing_Style"=>"sometimes|string",
        ];
    }
    

}
