<?php

namespace Modules\Payment\Services;

use App\Services\Services;
use Modules\User\Models\User;
use Modules\Payment\Models\Wallet;
use Illuminate\Support\Facades\DB;
use Exception;

class WalletService extends Services
{
 
    public function pay(User $user, float $amount, $referenceModel = null, string $description = '')
    {
        return DB::transaction(function () use ($user, $amount, $referenceModel, $description) {
            $wallet = $user->wallet()->lockForUpdate()->first();


            if ($wallet->balance < $amount) {
                return $this->setError(' not Enough Balance Please Charge Your Wallet');
            }

            $wallet->decrement('balance', $amount);

            return $wallet->transactions()->create([
                'type' => 'payment',
                'amount' => -$amount, 
                'balance_after' => $wallet->balance,
                'reference_id' => $referenceModel ? $referenceModel->id : null,
                'reference_type' => $referenceModel ? get_class($referenceModel) : null,
                'description' => $description,
            ]);
        });
    }

   
 


    public function deposit(User $user, float $amount, string $type = 'deposit', $referenceModel = null, string $description = '')
    {
        return DB::transaction(function () use ($user, $amount, $type, $referenceModel, $description) {
            $wallet = $user->wallet()->lockForUpdate()->first();

            $wallet->increment('balance', $amount);

            return $wallet->transactions()->create([
                'type' => $type,
                'amount' => $amount, 
                'balance_after' => $wallet->balance,
                'reference_id' => $referenceModel ? $referenceModel->id : null,
                'reference_type' => $referenceModel ? get_class($referenceModel) : null,
                'description' => $description,
            ]);
        });
    }
}