<?php

namespace Modules\Payment\Controllers;

use Illuminate\Http\Request;
use Stripe\Stripe;
use Stripe\Checkout\Session;
use App\Http\Controllers\Controller;
use Modules\Payment\Requests\ChargeWalletRequest;
use Modules\Payment\Services\PaymentService;

class PaymentController extends Controller
{

    protected $paymentService;

    public function __construct(PaymentService $paymentService)
    {
        $this->paymentService = $paymentService;
    }

    public function chargeWallet(ChargeWalletRequest $request)
    {
        $url = $this->paymentService->chargeWallet($request->amount);
        return response()->json([
            'url' => $url
        ]);
    }






    
    public function success()
    {
        return response()->json(['message' => 'Payment successful! Wallet balance will be updated shortly.']);
    }

    
    public function cancel()
    {
        return response()->json(['message' => 'Payment cancelled.']);
    }





}
