<?php

namespace Modules\Match\Jobs;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Modules\Match\Models\Matche;
use Modules\User\Models\User;

class UpdateMatchStatusesJob
{
    public function __construct()
    {
        //
    }

    public function handle(): void
    {
        $now = Carbon::now();
        $today = $now->format('Y-m-d');
        $currentTime = $now->format('H:i:s');

        \Illuminate\Support\Facades\Log::info("UpdateMatchStatusesJob running at: " . $now);

       
        $matchesToCancel = Matche::where('status', 'open')
            ->whereDate('date', '<=', $today)
            ->where(function ($q) use ($today, $currentTime) {
                $q->whereDate('date', '<', $today)
                    ->orWhere(function ($sub) use ($today, $currentTime) {
                        $sub->whereDate('date', '=', $today)
                            ->where('start_time', '<', $currentTime);
                    });
            })
            ->withCount('teamPlayers') 
            ->with('teamPlayers') 
            ->get();

        foreach ($matchesToCancel as $match) {
            $totalCapacity = $match->players_per_side * 2;


            if ($match->team_players_count < ($totalCapacity / 2)) {
                $match->update(['status' => 'cancelled']);
            }
        }

        
       $matchesIds = Matche::where('status', '!=', 'completed')
    ->where('status', '!=', 'cancelled')
    ->whereNotNull('end_time')
    ->where(function ($query) use ($today, $currentTime) {
        $query->whereDate('date', '<', $today)
              ->orWhere(function ($q) use ($today, $currentTime) {
                  $q->whereDate('date', '=', $today)
                    ->where('end_time', '<', $currentTime);
              });
    })
    ->pluck('id');

if ($matchesIds->isEmpty()) {
    return;
}

Matche::whereIn('id', $matchesIds)->update(['status' => 'completed']);

$userIds = DB::table('team_matches') 
            ->whereIn('match_id', $matchesIds)
            ->pluck('user_id');

// تحديث جماعي لكل البروفايلات دي
if ($userIds->isNotEmpty()) {
    User::whereIn('id', $userIds)->increment('Games_Played');
}

      
        Matche::where('status', 'open')
            ->whereNotNull('start_time')
            ->whereNotNull('end_time')
            ->whereDate('date', '=', $today)
            ->where('start_time', '<=', $currentTime)
            ->where('end_time', '>', $currentTime)
            ->update(['status' => 'ongoing']);

        $matchesToCheck = Matche::where('status', 'open')
            ->whereNotNull('start_time')
            ->whereRaw("CONCAT(DATE(date), ' ', start_time) <= ?", [$now->copy()->addMinutes(30)->toDateTimeString()])
            ->whereRaw("CONCAT(DATE(date), ' ', start_time) > ?", [$now->toDateTimeString()])
            ->withCount('teamPlayers')
            ->with('teamPlayers') // Eager load
            ->get();

        foreach ($matchesToCheck as $match) {
            $totalCapacity = $match->players_per_side * 2;
            if ($match->team_players_count < ($totalCapacity / 2)) {
                $match->update(['status' => 'cancelled']);
        
            }
        }
    }
}
