<?php

namespace Modules\Common\Controllers\Admin;

use App\Enum\UserType;
use App\Http\Controllers\Controller;
use App\Notifications\AdminNotifications;
use App\Notifications\AdminTopicNotifications;
use Illuminate\Support\Facades\Notification;
use Modules\Common\Models\AdminNotification;
use Modules\User\Models\User;

class NotificationController extends Controller
{
    public function notifications($id = null)
    {
        if (request()->isMethod('get')) {
            return $this->view();
        }

        if($id){
            $user = User::findOrFail($id);
            Notification::send($user , new AdminNotifications(request('title') ,request('content')));
            return response()->json(['url' => route('admin.users.index'), 'message' => __('Notification sent successfully')]);
        }elseif (request('user_id') && is_array(request('user_id'))) {
            Notification::send(User::whereIn('id', (array) request('user_id'))->get()
                , new AdminNotifications( request('title')  , request('content') ));

        }else{
            AdminNotification::create(request()->all());
            Notification::send(User::first() , new AdminTopicNotifications(request('for'), request('title') ,request('content')));
            return response()->json(['url' => route('admin.notifications'), 'message' => __('Notification sent successfully')]);
        }
        return response()->json(['url' => route('admin.notifications'), 'message' => __('Notification sent successfully')]);
    }

    private function view()
    {
        $notifications = AdminNotification::latest()->paginate(10);
        $title = "Notifications";

        $input = [
            "title" => __("users"),
            "name" => "user_id",
            "type" => "ajax_select",
            "action" => route('admin.get_users'),
            "values" => [],
            "empty" => 0
        ];
        $model = new User();
        return view('Common::admin.notifications', get_defined_vars());
    }

    public function notifications_delete($id)
    {
        AdminNotification::find($id)->delete();
        return response()->json(['url' => route('admin.notifications'), 'message' => __('Notification deleted successfully')]);
    }
}
