<?php

use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('Common::site.index');
});

Route::get('/.well-known/assetlinks.json', function () {
    return (array) json_decode('[
  {
    "relation": ["delegate_permission/common.handle_all_urls"],
    "target": {
      "namespace": "android_app",
      "package_name": "'.config('app_harag.packageName').'",
      "sha256_cert_fingerprints":
        ["'.config('app_harag.sha256_cert_fingerprints').'"]
    }
  }]');
});

Route::get('/.well-known/apple-app-site-association', function () {
    return [
        "applinks" => [
            "apps" => [],
            "details" => [
                [
                    "appID" => config('app_harag.IOS_TEAMID') . "." . config('app_harag.IOS_PACKAGE_NAME'),
                    "paths" => [
                        "/*"
                    ]
                ]
            ]
        ]
    ];
});
