<?php

namespace App\Http\Requests\Admin\Sliders;

use Illuminate\Foundation\Http\FormRequest;
use Modules\Sliders\Models\Slider;

class Store extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'image' => $this->route('slider') ? 'nullable|image':'required|image',
            'title' => 'required|string|max:250',
            'link' => 'nullable|url',
            'sort' => $this->route('slider') ? 'nullable':'required',
        ];
    }
    public function prepareForValidation()
    {
        if(!$this->route('slider')) {
            $lastSort = Slider::latest('sort')->value('sort');
            $this->merge([
                'sort' => ((int)@$lastSort) + 1,
            ]);
        }
    }
}
