<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Modules\Match\Models\Matche;
use Modules\Match\Jobs\SendMatchReminderJob;
use Illuminate\Support\Facades\Log;

class SendMatchReminders extends Command
{
    protected $signature = 'notify:match-reminders';
    protected $description = 'Dispatch jobs for match reminders (30, 15, 5 mins)';

    public function handle()
    {
        $intervals = [30, 15, 5];

        foreach ($intervals as $minutes) {
            $this->processInterval($minutes);
        }

        $this->info("All reminder checks completed.");
    }

    private function processInterval($minutes)
    {
        
        $targetDateTime = Carbon::now()->addMinutes($minutes);
        
        $targetDate = $targetDateTime->format('Y-m-d'); 
        $targetTime = $targetDateTime->format('H:i') . ':00';

        $this->info("Checking matches at: $targetDate $targetTime");
        Log::info("SendMatchReminders: Checking for matches at $targetDate $targetTime");

       
        Matche::whereDate('date', $targetDate) 
            ->whereTime('start_time', $targetTime)
            ->active()
            ->chunk(50, function ($matches) use ($minutes) {
                
                Log::info("SendMatchReminders: Found " . $matches->count() . " matches.");
                
                foreach ($matches as $match) {
                    dispatch(new SendMatchReminderJob($match, $minutes));
                }
           
            });
    }

}