<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Modules\Match\Models\Matche;
use Modules\Match\Jobs\ProcessMatchReviewJob;

class NotifyPostMatchReview extends Command
{
    protected $signature = 'notify:post-match-review';
    protected $description = 'Dispatch jobs to notify users to review their completed matches';

    public function handle()
    {
        $oneHourAgo = Carbon::now()->subHour();

        Matche::query()
            ->where('status', 'completed')
            ->where('is_review_notified', false)
        
            
            ->where('date', '>=', Carbon::now()->subDays(2)->format('Y-m-d')) 
            ->whereRaw("TIMESTAMP(date, end_time) <= ?", [$oneHourAgo]) 
            ->chunk(100, function ($matches) {
                
                foreach ($matches as $match) {
                    dispatch(new ProcessMatchReviewJob($match));
                }
            });

        $this->info("Post-match review jobs dispatched successfully.");
    }
}