<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Modules\Match\Models\Matche;
use Modules\Match\Jobs\NotifyMissingPlayersJob; 

class NotifyMatchesMissingPlayers extends Command
{
    protected $signature = 'notify:matches-missing-players';
    protected $description = 'Notify users about nearby matches missing players via Queue';


    public function handle()
    {
    
        $this->info("Starting match check...");

        Matche::whereBetween('date', [
                Carbon::now()->format('Y-m-d'), 
                Carbon::now()->addDay()->format('Y-m-d')
            ])
            ->active()
            ->withCount('teamPlayers') 
            ->chunk(50, function ($matches) {
                
                foreach ($matches as $match) {
                
                    $maxPlayers = $match->players_per_side * 2;
                    
                    if ($match->team_players_count >= $maxPlayers) {
                        continue;
                    }

                
                    dispatch(new NotifyMissingPlayersJob($match));
                    
                    $this->info("Dispatched job for Match ID: {$match->id}");
                }
            });

        $this->info("All jobs dispatched successfully!");
    }
}