<?php

namespace Modules\Reviews\Observers;

use Modules\Reviews\Models\Review;
use Modules\Match\Models\Matche;
use App\Notifications\NewCommentNotification;
use Illuminate\Support\Facades\Notification;
use Modules\User\Models\User;

class ReviewObserver
{
    public function created(Review $review)
    {

        // Check if the review is for a Match
        if ($review->reviewable_type === 'match' || $review->reviewable_type === Matche::class || $review->reviewable_type === 'Modules\Match\Models\Matche') {
            $match = $review->reviewable;

            if ($match) {
                // Get all participants (Team Players)
                $participants = $match->teamPlayers->pluck('id')->toArray();

                // Add Organizer
                $participants[] = $match->organizer_user_id;

                // Remove duplicates
                $userIds = array_unique($participants);

                // Exclude the user who wrote the comment
                $userIds = array_diff($userIds, [$review->user_id]);

                if (!empty($userIds)) {
                    $users = User::whereIn('id', $userIds)->get();
                    Notification::send($users, new NewCommentNotification($review));
                }         }
        
    }
}
}
