<?php

namespace Modules\Match\Jobs;

use Carbon\Carbon;
use Modules\Match\Models\Matche;

class UpdateMatchStatusesJob
{
    public function __construct()
    {
        //
    }

    public function handle(): void
    {
        $now = Carbon::now();
        $today = $now->format('Y-m-d');
        $currentTime = $now->format('H:i:s');

        \Illuminate\Support\Facades\Log::info("UpdateMatchStatusesJob running at: " . $now);

       
        $matchesToCancel = Matche::where('status', 'open')
            ->whereDate('date', '<=', $today)
            ->where(function ($q) use ($today, $currentTime) {
                $q->whereDate('date', '<', $today)
                    ->orWhere(function ($sub) use ($today, $currentTime) {
                        $sub->whereDate('date', '=', $today)
                            ->where('start_time', '<', $currentTime);
                    });
            })
            ->withCount('teamPlayers') 
            ->with('teamPlayers') 
            ->get();

        foreach ($matchesToCancel as $match) {
            $totalCapacity = $match->players_per_side * 2;


            if ($match->team_players_count < ($totalCapacity / 2)) {
                $match->update(['status' => 'cancelled']);
            }
        }

      
        $completedCount = Matche::where('status', '!=', 'completed')
            ->where('status', '!=', 'cancelled')
            ->whereNotNull('end_time')
            ->where(function ($query) use ($today, $currentTime) {
                $query->whereDate('date', '<', $today)
                    ->orWhere(function ($q) use ($today, $currentTime) {
                        $q->whereDate('date', '=', $today)
                            ->where('end_time', '<', $currentTime);
                    });
            })
            ->update(['status' => 'completed']);

        if ($completedCount > 0) {
            \Illuminate\Support\Facades\Log::info("Marked $completedCount matches as completed.");
        }

      
        Matche::where('status', 'open')
            ->whereNotNull('start_time')
            ->whereNotNull('end_time')
            ->whereDate('date', '=', $today)
            ->where('start_time', '<=', $currentTime)
            ->where('end_time', '>', $currentTime)
            ->update(['status' => 'ongoing']);

      

        $matchesToCheck = Matche::where('status', 'open')
            ->whereNotNull('start_time')
            ->whereRaw("CONCAT(DATE(date), ' ', start_time) <= ?", [$now->copy()->addMinutes(30)->toDateTimeString()])
            ->whereRaw("CONCAT(DATE(date), ' ', start_time) > ?", [$now->toDateTimeString()])
            ->withCount('teamPlayers')
            ->with('teamPlayers') // Eager load
            ->get();

        foreach ($matchesToCheck as $match) {
            $totalCapacity = $match->players_per_side * 2;
            if ($match->team_players_count < ($totalCapacity / 2)) {
                $match->update(['status' => 'cancelled']);
                \Illuminate\Support\Facades\Log::info("Cancelled match {$match->id} (Pre-start check)");
        
            }
        }
    }
}
