<?php

namespace Modules\Match\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Notification;
use App\Notifications\PostMatchReviewNotification;
use Modules\Match\Models\Matche;
use Illuminate\Support\Facades\Log;

class ProcessMatchReviewJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $match;
    public $tries = 3;

    public function __construct(Matche $match)
    {
        $this->match = $match;
    }

    public function handle()
    {

        $this->match->load(['teamPlayers.devices']);

        $players = $this->match->teamPlayers->filter(function ($user) {

         
            if (!$user->wantsNotification('Post-Match Review')) {
                Log::info("ProcessMatchReviewJob: User {$user->id} skipped (Notification disabled)");
                return false;
            }


            if ($user->devices->isEmpty()) {
                Log::info("ProcessMatchReviewJob: User {$user->id} skipped (No devices found)");
                return false;
            }

          
            foreach ($user->devices as $device) {
                Log::info("ProcessMatchReviewJob: User {$user->id} has device token: " . substr($device->token, 0, 10) . "...");
            }

            return true;
        });

  
        if ($players->count() > 0) {
            Log::info("ProcessMatchReviewJob: Sending Review Notification to {$players->count()} players for Match {$this->match->id}");
            Log::info("ProcessMatchReviewJob: Target User IDs: " . $players->pluck('id')->implode(', '));
            Notification::send($players, new PostMatchReviewNotification($this->match));
        } else {
            Log::info("ProcessMatchReviewJob: No eligible players found for Match {$this->match->id}");
        }

    
        $updated = $this->match->update(['is_review_notified' => true]);

    }
}
