<?php

namespace Modules\Location\Models;

use App\Traits\HasActive;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\User\Models\User;

use App\Traits\Translatable;

class Location extends Model
{
    use HasFactory, SoftDeletes, HasActive, Translatable;

    protected $translatable = ['name'];

    protected $fillable = [
        'name',
        'name_ar',
        'status',
    ];
    protected $casts = [
        'status' => 'boolean'
    ];

    public function users()
    {
        return $this->belongsToMany(User::class, 'position_id', 'id');
    }
}
