<?php

namespace Modules\Categories\Controllers;

use Modules\Categories\Models\Category;
use Modules\Categories\Requests\StoreCategoryRequest;
use Modules\Common\Controllers\Admin\HelperController;



class AdminController extends HelperController
{


    public function __construct()
    {
        $this->model = new Category();
        $this->rows  = $this->model->query();

        $this->title = "Categories";
        $this->name  = "categories";
        $this->formRequest = StoreCategoryRequest::class;
    }

    public function listBuilder()
    {
        $this->list = [
            'name' => __('name'),
            'description' => __('description'),
            'status_text' => __('status'),
            'visual' => __('Image/Video'),
        ];
    }

    public function formBuilder()
    {
        $this->inputs = [
            'name' => ['title' => __('name')],
            'name_ar' => ['title' => __('name_ar')],
            'description' => ['title' => __('description')],
            'description_ar' => ['title' => __('description_ar')],
            'status' => ['title' => __('status'), 'type' => 'select', 'values' => [1 => __('active'), 0 => __('inactive')]],
            'media[]' => ['title' => __('Image/Video'), 'type' => 'image', 'multiple' => true],
        ];
    }

    public function setImages($model)
    {
        // Prevent default image creation logic
    }
}
