@extends('Common::admin.layout.page')

@section('page')
    <div class="row">
        <div class="col-sm-12">
            <!-- general form elements -->
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">
                        {{ __('show user') }}
                    </h3>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-stripped">
                        <tbody>
                            <tr>
                                <th>{{ __('name') }}</th>
                                <td>{{ $user->name }}</td>
                            </tr>
                            <tr>
                                <th>{{ __('mobile') }}</th>
                                <td>{{ $user->mobile }}</td>
                            </tr>
                            <tr>
                                <th>{{ __('Email') }}</th>
                                <td>{{ $user->email }}</td>
                            </tr>
                            @if($user->type != \App\Enum\UserType::SUPERVISOR)
                                <tr>
                                    <th>{{ __('Location in playground') }}</th>
                                    <td>{{ $user->location?->name }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('is couching') }}</th>
                                    <td>{{ $user->type == \App\Enum\UserType::COACH ? __('Yes') : __('No') }}</td>
                                </tr>
                            @endif
                            <tr>
                                <th>{{ __('Profile Image') }}</th>
                                <td>
                                    @if ($user->image)
                                        <a href="{{ $user->image }}" target="_blank" style="font-size:13px">عرض المرفق</a>
                                    @endif
                                    <!-- use thumbnails -->
                                    <img class="img-thumbnail" src="{{ $user->image }}" width="200" height="150" alt="" />
                                </td>
                            </tr>
                            <tr>
                                <th>{{ __('is blocked') }}</th>
                                <td>{{ $user->banned ? __('Yes') : __('No') }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
</div>
@stop
