<?php

use Modules\User\Controllers\Api\{ApiController, AuthController,};

Route::group(['namespace' => 'Api' , 'middleware' => 'api'], function () {
    Route::post('login', [AuthController::class,'login']);
    Route::post('signup', [AuthController::class,'signup']);
    Route::post('activate', [AuthController::class,'activate']);
    Route::post('resend_code', [AuthController::class,'resend_code']);

    Route::group(['middleware' => ['auth:sanctum','auth-check']], function () {
        Route::post('logout', [AuthController::class,'logout']);
        Route::get('profile', [ApiController::class,'profile']);
        Route::post('edit_profile', [ApiController::class,'update']);
        Route::delete('delete_profile', [ApiController::class,'delete']);
        Route::post('confirm_mobile', [ApiController::class,'confirm_mobile']);

        Route::post('coach-request', [ApiController::class,'coachRequest']);
    });
});
