<?php

namespace Modules\User\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    =>  (int) $this->id,
            'name'  =>  (string) $this->name,
            'mobile'   =>   (string) $this->mobile,
            'email'   =>   (string) $this->email,
            'image' =>  $this->image,
            'notify' =>  (bool) $this->notify,
            'lang' =>  $this->lang,
            'banned' =>  (bool) $this->banned,
            'active' => (bool) $this->status,
            'type' => (string) $this->type,
            'location_id' => (int) $this->location_id,
            'location' => (string) $this->location?->name,
            'area_id' => (int) $this->area_id,
            'area' => (string) $this->area?->name,
            'coaching' => (string) @$this->coachingRequest()->first()['status'],
            'role' => $this->pivot->role ?? null,
        ];
    }
}
