<?php

namespace Modules\User\Requests;

use App\Enum\UserType;
use Illuminate\Foundation\Http\FormRequest;
use Modules\User\Models\User;

class SupervisorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|min:1|max:60',
            'image' => 'nullable|image',
            'mobile' => 'required|unique:users,mobile,' . $this->route('supervisor').',id,deleted_at,NULL|regex:/^05\d{8}$/',
            'email' => 'required|email|unique:users,email,' . $this->route('supervisor').',id,deleted_at,NULL|email',
            'area_id' => 'required|exists:areas,id,deleted_at,NULL',
            'password' => 'required',
            'type' => 'required',
            'playground_id' => 'required|array',
            'playground_id.*' => 'required|exists:playgrounds,id,deleted_at,NULL',
        ];
    }
    protected function prepareForValidation()
    {
        $mobile = (string) convert_to_english($this->input('mobile'));
        if($mobile){
            if(!str_starts_with($mobile,0)){
                $mobile = '0'.$mobile;
            }
            $this->merge([
                'mobile' => $mobile,
                'password' => 'P@ssw0rd',
                'type' => UserType::SUPERVISOR,
            ]);
        }
    }
}
