<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('email')->unique()->nullable();
            $table->boolean('status')->default(false);
            $table->string('mobile')->unique();
            $table->string('new_mobile')->nullable();
            $table->string('password');
            $table->foreignIdFor(\Modules\Areas\Models\Area::class)->nullable()->index()->constrained();
            $table->decimal('wallet',20,2)->default(0);
            $table->string('lang', 2)->default('ar');
            $table->string('type', 20)->default(\App\Enum\UserType::CLIENT);
            $table->boolean('notify')->default(true);
            $table->boolean('banned')->default(false);
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
