<?php

namespace Modules\User\Controllers\Api;

use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Modules\User\Models\Otp;
use Modules\User\Models\User;
use Modules\User\Requests\CheckMobileOtpRequest;
use Modules\User\Requests\LoginRequest;
use Modules\User\Requests\LogoutRequest;
use Modules\User\Requests\RegisterRequest;
use Modules\User\Requests\SendMobileOtpRequest;
use Modules\User\Resources\UserResource;
use Modules\User\Services\UserService;

class AuthController extends Controller
{
    public function signup(RegisterRequest $request)
    {
        $user = User::create($request->validated());
        $code = Confirmation::sendCode($user);
        return ApiResponse::created([
            'mobile' => $user->full_phone,
            'code' => 11111
            // 'code' => $code
        ], __('messages.Verification code sent to your mobile'), 302);
    }

    public function resend_code(SendMobileOtpRequest $request)
    {
        $user = User::where('mobile', $request->mobile)->first();
        $code = Confirmation::sendCode($user);
        return ApiResponse::loaded([
            'mobile' => $user->full_phone,
            'code' => $code
        ], 200, __('messages.Confirmation code resent to your mobile'));
    }
    public function activate(CheckMobileOtpRequest $request)
    {
        // Check if OTP is '11111' for testing
        if ($request->code === '11111') {
            $user = User::where('mobile', $request->mobile)->first();
            if (!$user) {
                return ApiResponse::failed(__('messages.User not found'));
            }
            UserService::addDevice($user);
            $user->update(['status' => 1]);
            $access_token = $user->createToken('authToken')->plainTextToken;
            return ApiResponse::loaded([
                'user' => UserResource::make($user),
                'access_token' => $access_token,
                'type' => $user->type,
            ], 200, __('messages.Your account activated successfully (test mode)'));
        }

        // Original OTP verification logic
        $token = Otp::where('otp', $request->code)->where('status', false)
            ->whereRelation('user', 'mobile', '=', $request->mobile)
            ->first();
        if (!$token) {
            return ApiResponse::failed(__('Activation code is not correct'));
        }
        if ($token->expired_at < Carbon::now()->format('Y-m-d H:i:s')) {
            return ApiResponse::failed(__('Activation code is expired'));
        }
        $user = $token->user;
        UserService::addDevice($user);
        $token->update(['status' => 1]);
        $user->update(['status' => 1]);
        $access_token = $user->createToken('authToken')->plainTextToken;
        return ApiResponse::loaded([
            'user' => UserResource::make($user),
            'access_token' => $access_token,
            'type' => $user->type,
        ], 200, __('messages.Your account activated successfully'));
    }

    // TODO: add when back to production
    /* public function activate(CheckMobileOtpRequest $request)
    {
        $token = Otp::where('otp', $request->code)->where('status',false)
            ->whereRelation('user', 'mobile', '=', $request->mobile)
            ->first();
        if (!$token) {
            return ApiResponse::failed(__('Activation code is not correct'));
        }
        if ($token->expired_at < Carbon::now()->format('Y-m-d H:i:s')) {
            return ApiResponse::failed(__('Activation code is expired'));
        }
        $user = $token->user;
        UserService::addDevice($user);
        $token->update(['status' => 1]);
        $user->update(['status' => 1]);
        $access_token = $user->createToken('authToken')->plainTextToken;
        return ApiResponse::loaded([
            'user' => UserResource::make($user),
            'access_token' => $access_token,
            'type' => $user->type,
        ],200,'Your account activated successfully');
    }
    //todo: readd this in production. comment it for testing only
    /*   public function login(LoginRequest $request)
    {
        $user = User::whereMobile($request->mobile)->first();
        if(!$user){
            return ApiResponse::loaded(null,307,'Mobile not found');
        }
        if (@$user->banned) {
            return ApiResponse::failed(__('Your account is blocked'));
        }
        $code = Confirmation::sendCode($user);
        return ApiResponse::loaded([
            'mobile' => $user->full_phone,
            'code' => $code
        ],302);
    }*/

    public function login(LoginRequest $request)
    {
        $user = User::whereMobile($request->mobile)->first();
        if (!$user) {
            return ApiResponse::loaded(null, 307, __('messages.Mobile not found'));
        }
        if (@$user->banned) {
            return ApiResponse::failed(__('messages.Your account is blocked'));
        }
        $code = Confirmation::sendCode($user);
        return ApiResponse::loaded([
            'mobile' => $user->full_phone,
            'code' => $code
        ], 302);
    }

    public function logout(LogoutRequest $request)
    {
        $user = auth()->user();
        $user->devices()->whereUuid($request->uuid)->delete();
        $request->user()->currentAccessToken()->delete();
        return ApiResponse::loaded(null, 200, 'Logged out successfully');
    }
}
