<?php

namespace Modules\User\Controllers\Admin;

use Modules\User\Models\User;
use Illuminate\Http\Request;
use Modules\Common\Controllers\Admin\HelperController;
use Modules\User\Models\Admin;
use Modules\User\Models\Role;
use Modules\User\Requests\AdminRequest;

class ModeratorsController extends HelperController
{
    public function __construct()
    {
        $this->roleName = "Roles";

        $this->model = new Admin;
        $this->rows = Admin::where('id', '!=', 1)->with('role');
        $this->title = "Moderators";
        $this->name =  'moderators';

        $this->formRequest = AdminRequest::class;
    }

    public function listBuilder()
    {
        $this->list = [
            'name' => __('name'),
            'role_name' => __('role')
        ];
        $this->switches['status'] = route('admin.users.active_status');
    }

    public function formBuilder()
    {
        $roles = Role::pluck('name', 'id');
        $this->inputs = [
            'role_id'  =>  ['title'    =>  __('role'), 'type' => 'select', 'values' => $roles],
            'name'  =>  ['title'    =>  __('name')],
            'email'  =>  ['title'    =>  __('email')],
            'mobile'  =>  ['title'    =>  __('phone'), 'empty' => 1],
            'password'  =>  ['title'    =>  __('password'), 'type' => 'password'],
            'image'  =>  ['title'    =>  __('image'), 'type' => 'image', 'empty' => 1],
        ];
    }

    public function active_status(Request $request)
    {
        $user = User::findOrFail($request->id);
        if ($user->status == 1) {
            $status = 0;
        } else {
            $status = 1;
            if ($user->type == 'provider' && $device = $user->device) {
                send_fcm([$device->token], $device->platform, __('Your account activated as provider'), 'provider', $user->id, 'provider');
            }
        }
        $user->update(['status' => $status]);
        return \MshMsh\Helpers\ApiResponsder::get('', ['status' => 1]);
    }
}
