@extends('Common::admin.layout.page')

@section('page')
    <div class="container-fluid">
        <div class="row mb-4">
            <div class="col-12">
                <div class="card bg-light shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h3 class="card-title mb-0">{{ __('teams.Manage Members for Team:') }} {{ $team->name }}</h3>
                    </div>
                    <div class="card-body">

                        <form method="POST" action="{{ route('admin.teams.members.add', $team->id) }}" class="mb-4">
                            @csrf
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">{{ __('teams.Add Member') }}</h5>
                                </div>
                                <div class="card-body row">
                                    <div class="form-group mb-2 col-md-6">
                                        <label for="add_member_id">{{ __('teams.Phone Number') }}</label>
                                        <input type="text" name="user_phone" id="add_member_id" class="form-control"
                                            placeholder="{{ __('teams.Phone Number') }}">
                                    </div>
                                    <div class="form-group mb-2 col-md-6">
                                        <label for="add_member_role">{{ __('teams.Role') }}</label>
                                        <select name="role" id="add_member_role" class="form-control">
                                            @foreach ($roles as $roleKey => $roleName)
                                                <option value="{{ $roleKey }}">{{ $roleName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12 py-3 px-5">
                                        <button type="submit" class="btn btn-primary w-100">{{ __('Add') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover bg-white">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>{{ __('Member') }}</th>
                                        <th>{{ __('Location') }}</th>
                                        <th>{{ __('Role') }}</th>
                                        <th>{{ __('teams.Remove') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($team->users as $user)
                                        <tr id="member-row-{{ $user->id }}">
                                            <td class="align-middle">{{ $user->name }}</td>
                                            <td class="align-middle">
                                                {{ $user->location ? $user->location->name : __('No location') }}</td>
                                            <td class="align-middle">
                                                <form method="POST"
                                                    action="{{ route('admin.teams.members.roles', $team->id) }}"
                                                    class="d-inline-flex align-items-center">
                                                    @csrf
                                                    <input type="hidden" name="members[{{ $user->id }}]"
                                                        value="">
                                                    <select name="members[{{ $user->id }}]"
                                                        class="form-control form-select-sm d-inline w-auto"
                                                        onchange="this.form.submit()">
                                                        @foreach ($roles as $roleKey => $roleName)
                                                            <option value="{{ $roleKey }}"
                                                                @if ($user->pivot->role == $roleKey) selected @endif>
                                                                {{ $roleName }}</option>
                                                        @endforeach
                                                    </select>
                                                </form>
                                            </td>
                                            <td class="align-middle text-center">
                                                <form method="POST"
                                                    action="{{ route('admin.teams.members.remove', $team->id) }}"
                                                    style="display:inline;">
                                                    @csrf
                                                    <input type="hidden" name="user_ids[]" value="{{ $user->id }}">
                                                    <button type="submit" class="btn btn-danger btn-sm"
                                                        onclick="return confirm('{{ __('Are you sure you want to remove this member?') }}')">
                                                        <i class="fa fa-trash"></i> {{ __('Remove') }}
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('js')
        <script>
            $(document).ready(function() {
                $('#add_member_id').select2({
                    placeholder: "{{ __('Select User') }}",
                    allowClear: true,
                    width: '100%'
                });
            });

            function removeMember(userId) {
                // Mark the checkbox as checked and hide the row visually
                document.getElementById('remove-checkbox-' + userId).checked = true;
                document.getElementById('member-row-' + userId).style.backgroundColor = '#f8d7da';
                document.getElementById('member-row-' + userId).style.opacity = 0.5;
            }
        </script>
    @endpush
@endsection
