@extends('Common::admin.layout.index')

@section('page')
    <h3>Teams Index</h3>
    <table>
        <thead>
            <tr>
                <th>{{ __('Name') }}</th>
                <th>{{ __('Area') }}</th>
                <th>{{ __('Members') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($teams as $team)
                <tr>
                    <td>{{ $team->name }}</td>
                    <td>{{ $team->area ? $team->area->name : '' }}</td>
                    <td>
                        <a href="{{ route('admin.teams.members', $team->id) }}"
                            class="btn btn-primary">{{ __('Manage Members') }}</a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@stop
