<?php

use Illuminate\Support\Facades\Route;
use Modules\Teams\Controllers\ApiController;

Route::group([
    'middleware' => ['auth:sanctum', 'auth-check'],
    'prefix' => 'team',
    'controller' => ApiController::class
], function () {
    Route::get('/all-active', 'allActiveTeams')->name('team.all-active');
    Route::get('/show/{id}', 'show')->name('team.show');
    Route::post('/store', 'store')->name('team.store');
    Route::get('/user-teams', 'userTeams')->name('user-teams.index');
    Route::post('/update/{id}', 'update')->name('team.update');
    Route::delete('/destroy/{id}', 'destroy')->name('team.destroy');

    Route::post('/add-member', 'addMember')->name('team.add-member');
    Route::post('/remove-member', 'removeMember')->name('team.remove-member');
    Route::post('/member-role', 'memberRole')->name('team.member-role');
    Route::post('/leave/{id}', 'leaveTeam')->name('team.leave');
});
