<?php

use Illuminate\Support\Facades\Route;
use Modules\Teams\Controllers\AdminController;

Route::get('teams', [AdminController::class, 'index'])->name('teams.index');
Route::get('teams/create', [AdminController::class, 'create'])->name('teams.create');
Route::get('teams/{id}/edit', [AdminController::class, 'edit'])->name('teams.edit');
Route::delete('teams/{id}', [AdminController::class, 'destroy'])->name('teams.destroy');
Route::get('teams/active-status', [AdminController::class, 'active_status'])->name('teams.active_status');
Route::get('teams/members', [AdminController::class, 'members'])->name('teams.members');
Route::get('teams/{id}/members', [AdminController::class, 'members'])->name('teams.members');
Route::post('teams/{id}/members', [AdminController::class, 'updateMembers'])->name('teams.members.update');
Route::post('teams', [AdminController::class, 'store'])->name('teams.store');
Route::put('teams/{id}', [AdminController::class, 'update'])->name('teams.update');
Route::post('teams/{id}/members/add', [AdminController::class, 'addMember'])->name('teams.members.add');
Route::post('teams/{id}/members/remove', [AdminController::class, 'removeMembers'])->name('teams.members.remove');
Route::post('teams/{id}/members/roles', [AdminController::class, 'updateRoles'])->name('teams.members.roles');
