<?php

namespace Modules\Teams\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\User\Resources\UserResource;
use Illuminate\Support\Facades\Storage;
use Modules\Teams\Helpers\LevelHelper;

class TeamResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => (string) $this->name,
            'status' => (bool) $this->status,
            'logo_url' => $this->logo ? Storage::disk('public')->url($this->logo) : null,
            'area_id' => $this->area_id,
            'bio' => $this->bio,
            'trophies' => [
                'remuntada_challenge_league' => (int) $this->remuntada_challenge_league,
                'remuntada_elite_cup' => (int) $this->remuntada_elite_cup,
                'remuntada_super_cup' => (int) $this->remuntada_super_cup,
                'total' => (int) ($this->remuntada_challenge_league + $this->remuntada_elite_cup + $this->remuntada_super_cup),
            ],
            'leader' => $this->whenLoaded('leader', function () {
                return new UserResource($this->leader->first());
            }),
            'members_count' => $this->whenLoaded('users', function () {
                return $this->users->count();
            }),
            'users' => UserResource::collection($this->whenLoaded('users')),
            'rankings' => [
                'competitive' => $this->whenLoaded('competitiveRanking', function () {
                    $ranking = $this->competitiveRanking;
                    if (!$ranking) return null;

                    return [
                        'wins' => (int) $ranking->wins,
                        'draws' => (int) $ranking->draws,
                        'losses' => (int) $ranking->losses,
                        'owns' => (int) $ranking->owns,
                        'match_count' => (int) ($ranking->wins + $ranking->draws + $ranking->losses),
                        'againsts' => (int) $ranking->againsts,
                        'points' => (int) $ranking->points,
                        'level' => LevelHelper::getCurrentLevel($ranking->level, $ranking->is_competitive),
                        'level_color' => LevelHelper::getLevelColor($ranking->level, $ranking->is_competitive),
                        'is_competitive' => (bool) $ranking->is_competitive,
                    ];
                }),
                'friendly' => $this->whenLoaded('friendlyRanking', function () {
                    $ranking = $this->friendlyRanking;
                    if (!$ranking) return null;

                    return [
                        'wins' => (int) $ranking->wins,
                        'draws' => (int) $ranking->draws,
                        'losses' => (int) $ranking->losses,
                        'match_count' => (int) ($ranking->wins + $ranking->draws + $ranking->losses),
                        'owns' => (int) $ranking->owns,
                        'againsts' => (int) $ranking->againsts,
                        'points' => (int) $ranking->points,
                        'is_competitive' => (bool) $ranking->is_competitive,
                    ];
                }),
            ],
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
