<?php

namespace Modules\Teams\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateTeamRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $teamId = $this->team ?? $this->id ?? null;

        return [
            'name' => 'sometimes|string|max:255|unique:teams,name,' . ($teamId ?? 'NULL') . ',id',
            'logo' => 'sometimes|image|mimes:jpeg,jpg,png,gif,webp|max:2048',
            'area_id' => 'sometimes|integer|exists:areas,id',
            'bio' => 'sometimes|string|max:255',
        ];
    }
}
