<?php

namespace Modules\Teams\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TeamRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:255|unique:teams,name,',
            'logo' => 'nullable|image|mimes:jpeg,jpg,png,gif,webp|max:2048',
            'area_id' => 'required|integer|exists:areas,id',
            'bio' => 'nullable|string|max:255',
        ];
    }
}
