<?php

namespace Modules\Teams\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ChangeRoleRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'phone_number' => 'required|string|exists:users,mobile',
            'team_id' => 'required|integer|exists:teams,id',
            'role' => 'required|string|in:subleader,member,leader'
        ];
    }
}
