<?php

namespace Modules\Teams\Models;

use App\Traits\HasActive;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\User\Models\User;


class TeamUser  extends Model
{
    use HasFactory, HasActive;
    protected $table = 'team_user';
    protected $fillable = [
        'team_id',
        'user_id',
        'role',
    ];

    /**
     * Get the team that owns the team user
     */
    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    /**
     * Get the user that owns the team user
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

}
