<?php

namespace Modules\Teams\Helpers;

class LevelHelper
{

    /**
     * Get level translation in current locale
     *
     * @param string|null $level
     * @param bool $isCompetitive
     * @param string $locale
     * @return string|null
     */
    public static function getLevelInLocale($level, $isCompetitive = true, $locale = null)
    {
        if (!$isCompetitive || !$level) {
            return null;
        }

        $locale = $locale ?? app()->getLocale();
        return __('teams.levels.' . $level . '.name', [], $locale) ?? $level;
    }

    /**
     * Get level in current application locale
     *
     * @param string|null $level
     * @param bool $isCompetitive
     * @return string|null
     */
    public static function getCurrentLevel($level, $isCompetitive = true)
    {
        if (!$isCompetitive || !$level) {
            return null;
        }

        $translation = __('teams.levels.' . $level . '.name');
        
        if ($translation === 'teams.levels.' . $level . '.name') {
            return $level;
        }
        return $translation;
    }

    /**
     * Get all available levels
     *
     * @return array
     */
    public static function getAllLevels()
    {
        return [
            'Bronze1',
            'Bronze2',
            'Bronze3',
            'Silver1',
            'Silver2',
            'Silver3',
            'Gold1',
            'Gold2',
            'Gold3',
            'Platinum1',
            'Platinum2',
            'Platinum3',
            'Legendary1',
            'Legendary2',
            'Legendary3',
            'Elite1',
            'Elite2',
            'Elite3',
            'Master'
        ];
    }

    /**
     * Get level order (for sorting)
     *
     * @param string $level
     * @return int
     */
    public static function getLevelOrder($level)
    {
        $levels = self::getAllLevels();
        return array_search($level, $levels) !== false ? array_search($level, $levels) : 0;
    }

    /**
     * Get color for a level
     *
     * @param string|null $level
     * @param bool $isCompetitive
     * @return string|null
     */
    public static function getLevelColor($level, $isCompetitive = true)
    {
        if (!$isCompetitive || !$level) {
            return null;
        }

        $translation = __('teams.levels.' . $level . '.color');
        // If translation returns the key itself, it means translation wasn't found
        if ($translation === 'teams.levels.' . $level . '.color') {
            return null;
        }
        return $translation;
    }
}
