<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('team_rankings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('team_id')->constrained('teams')->onDelete('cascade');
            $table->integer('wins')->default(0);
            $table->integer('draws')->default(0);
            $table->integer('losses')->default(0);
            $table->integer('owns')->default(0);
            $table->integer('againsts')->default(0);
            $table->enum('level', [
                'Bronze1',
                'Bronze2',
                'Bronze3',
                'Silver1',
                'Silver2',
                'Silver3',
                'Gold1',
                'Gold2',
                'Gold3',
                'Platinum1',
                'Platinum2',
                'Platinum3',
                'Legendary1',
                'Legendary2',
                'Legendary3',
                'Elite1',
                'Elite2',
                'Elite3',
                'Master'
            ])->default('Bronze1');
            $table->integer('points')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('team_rankings');
    }
};
