<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('teams', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->boolean('status')->default(false);
            $table->string('logo')->nullable();
            $table->foreignId('area_id')->constrained('areas')->onDelete('cascade');
            $table->text('bio')->nullable();
            $table->unsignedInteger('remuntada_challenge_league')->default(0);
            $table->unsignedInteger('remuntada_elite_cup')->default(0);
            $table->unsignedInteger('remuntada_super_cup')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('teams');
    }
};
