<?php

namespace Modules\Playground\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PlaygroundResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    =>  $this->id,
            'name'    =>  (string) $this->name,
            'location'    =>  LocationMapResource::make($this->location),
        ];
    }
}
