<?php

namespace Modules\Playground\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class LocationMapResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lat = (string) @$this['lat'];
        $lng = (string) @$this['lng'];
        $location = (string) @$this['text'];

        $googleMapsLink = "https://www.google.com/maps?q={$lat},{$lng}&hl=ar&z=18";

        return [
            'lat' => $lat,
            'lng' => $lng,
            'location' => $location,
            'google_maps_link' => $googleMapsLink,
        ];
    }
}
