<?php

namespace Modules\Playground\Models;

use App\Traits\HasActive;
use App\Traits\HelperModelTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Areas\Models\Area;

class Playground extends Model
{
    use HasFactory,SoftDeletes,HasActive,HelperModelTrait;
    protected $fillable = [
        'name',
        'location',
        'area_id',
        'status',
    ];
    protected $casts = [
        'status'=>'boolean',
        'location'=>'array',
    ];

    public function scopeNearest($query,$lat,$lng)
    {
        if($lat && $lng){
            $distanceQuery = "
            ( 6371 * acos( cos( radians(?) ) *
            cos( radians( JSON_UNQUOTE(JSON_EXTRACT(location, '$.lat')) ) )
            * cos( radians( JSON_UNQUOTE(JSON_EXTRACT(location, '$.lng')) ) - radians(?) )
            + sin( radians(?) ) *
            sin( radians( JSON_UNQUOTE(JSON_EXTRACT(location, '$.lat')) ) ) ) )
            AS distance
            ";
            return $query->select('playgrounds.*')->selectRaw($distanceQuery, [$lat, $lng, $lat])->orderBy('distance', 'asc');
        }

    }

    public function area()
    {
        return $this->belongsTo(Area::class);
    }
}
