<?php

namespace Modules\Playground\Controllers;

use App\Enum\UserType;
use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use Modules\Playground\Resources\PlaygroundListResource;
use Modules\Playground\Resources\PlaygroundResource;
use Modules\Playground\Models\Playground;

class ApiController extends Controller
{
    public function index()
    {
        $user = auth('api')->user();
        if(auth('api')->check() && $user->type == UserType::SUPERVISOR){
            $playgrounds = $user->playgrounds()->active()->get();
        }else{
            $playgrounds = Playground::active()->nearest(request()->header('lat'),request()->header('lng'))->get();
        }
        return ApiResponse::loaded([
            'playgrounds' => PlaygroundResource::collection($playgrounds)
        ]);
    }
    public function list()
    {
        $playgrounds = Playground::active()->get();
        return ApiResponse::loaded([
            'playgrounds' => PlaygroundListResource::collection($playgrounds)
        ]);
    }
}
